package cn.smarthse.rho.modules.sys.model.e.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


@Data
public class ERelationVo implements Serializable{
	private static final long serialVersionUID = 9144564466024417533L;
	
	
	private Long id;
	
	/**
	 * 放射源/核素id
	 */
	//@ApiModelProperty(value = "放射源/核素id")
	private Long sourceId;
	
	/**
	 * 机房id
	 */
	//@ApiModelProperty(value = "机房id")
	private Long roomId;
	
	/**
	 * 设备id
	 */
	//@ApiModelProperty(value = "设备id")
	private Long deviceId;

	/**
	 * 变更日期
	 */
	//@ApiModelProperty(value = "变更日期")
	private Date changeDate;
	
	/**
	 * 是否为当前生效的关系(0-不是；1-是)
	 */
	//@ApiModelProperty(value = "是否为当前生效的关系(0-不是；1-是)")
	private Integer isCur;

	/**
	 * 三同时项目id（f_project.id）
	 */
	//@ApiModelProperty(value = "三同时项目id（f_project.id）")
	private Long projectId;

	/**
	 * 变更前装置/机房名称
	 */
	//@ApiModelProperty(value = "变更前装置/机房名称")
	private String beforeChangeName;

	/**
	 * 变更后装置/机房名称
	 */
	//@ApiModelProperty(value = "变更后装置/机房名称")
	private String afterChangeName;

	/**
	 * 操作人name
	 */
	@Desensitization(type = DesensitizationType.NAME)
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String operatorName;

}
