package cn.smarthse.rho.modules.sys.model.e.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 机房详情 - 放射性同位素vo
 */
@Data
public class EMachineRoomSourceVo implements Serializable{
	private static final long serialVersionUID = -5899857669556023049L;
	
	private Long id;

	/**
	 * 名称
	 */
	//@ApiModelProperty(value = "名称")
	private String name;

	/**
	 * 生产厂家
	 */
	//@ApiModelProperty(value = "生产厂家")
	private String factory;

	/**
	 * 状态（1-正常；2-暂停使用；3-退役/报废）
	 */
	//@ApiModelProperty(value = "状态（1-正常；2-暂停使用；3-退役/报废）")
	private Integer status;

	/**
	 * 许可状态(1-未许可；2-已许可；3-许可注销)
	 */
	//@ApiModelProperty(value = "许可状态(1-未许可；2-已许可；3-许可注销)")
	private Integer licenseStatus;

	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	//@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）")
	private Integer type;


	/**
	 * 使用科室Name
	 */
	//@ApiModelProperty(value = "使用科室Name")
	private String useDepartmentName;

	/**
	 * (核素)用途
	 */
	//@ApiModelProperty(value = "(核素)用途")
	private String useTo;


	// ************************************************ 密封放射源
	/**
	 * 出厂活度（前，保留两位小数）
	 */
	//@ApiModelProperty(value = "出厂活度（前，保留两位小数）")
	private Float sealedData1;

	/**
	 * 出厂活度（后）
	 */
	//@ApiModelProperty(value = "出厂活度（后）")
	private Integer sealedData2;

	/**
	 * 出厂日期
	 */
	//@ApiModelProperty(value = "出厂日期")
	private Date productionDate;

	/**
	 * 活度测量日期
	 */
	//@ApiModelProperty(value = "活度测量日期")
	private Date measurementDate;
	// ************************************************ 密封放射源



	// ************************************************ non密封放射源
	/**
	 * 物理状态（1-固态；2-液态；3-气态）
	 */
	//@ApiModelProperty(value = "物理状态（1-固态；2-液态；3-气态）")
	private Integer physicalState;

	/**
	 * 最大等效日操作量(前，保留两位小数)
	 */
	//@ApiModelProperty(value = "最大等效日操作量(前，保留两位小数)")
	private Float nonSealedData1;

	/**
	 * 最大等效日操作量(后)
	 */
	//@ApiModelProperty(value = "最大等效日操作量(后)")
	private Integer nonSealedData2;

	/**
	 * 最大等效年操作量(前，保留两位小数)
	 */
	//@ApiModelProperty(value = "最大等效年操作量(前，保留两位小数)")
	private Float nonSealedData3;

	/**
	 * 最大等效年操作量(后)
	 */
	//@ApiModelProperty(value = "最大等效年操作量(后)")
	private Integer nonSealedData4;
	// ************************************************ non密封放射源

}
