package cn.smarthse.rho.modules.sys.model.e.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 机房详情 - 射线装置vo
 */
@Data
public class EMachineRoomDeviceVo implements Serializable{
	private static final long serialVersionUID = -5616595192595152321L;
	
	private Long id;

	/**
	 * 名称
	 */
	//@ApiModelProperty(value = "名称")
	private String name;

	/**
	 * 生产厂家
	 */
	//@ApiModelProperty(value = "生产厂家")
	private String factory;

	/**
	 * 使用科室Name
	 */
	//@ApiModelProperty(value = "使用科室Name")
	private String useDepartmentName;

	/**
	 * 出厂日期
	 */
	//@ApiModelProperty(value = "出厂日期")
	private Date productionDate;

	/**
	 * 状态（1-正常；2-暂停使用；3-退役/报废）
	 */
	//@ApiModelProperty(value = "状态（1-正常；2-暂停使用；3-退役/报废）")
	private Integer status;

	/**
	 * 许可状态(1-未许可；2-已许可；3-许可注销)
	 */
	//@ApiModelProperty(value = "许可状态(1-未许可；2-已许可；3-许可注销)")
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	//@ApiModelProperty(value = "已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
	private Integer licenseStatusType;

	/**
	 * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	 */
	//@ApiModelProperty(value = "预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)")
	private Integer warningStatus;

	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	//@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）")
	private Integer type;

	// ************************************************ 射线装置
	/**
	 * 射线装置 - 型号
	 */
	//@ApiModelProperty(value = "射线装置 - 型号")
	private String rayModel;

	/**
	 * 编号
	 */
	//@ApiModelProperty(value = "编号")
	private String factoryNo;

	/**
	 * 主要参数
	 */
	//@ApiModelProperty(value = "主要参数")
	private String parameters;
	// ************************************************ 射线装置



	// ************************************************ 含密封源装置
	/**
	 * 含密封源装置 - 型号
	 */
	//@ApiModelProperty(value = "含密封源装置 - 型号")
	private String sourceModel;

	/**
	 * 核素名称
	 */
	//@ApiModelProperty(value = "核素名称")
	private String sealName;

	/**
	 * 出厂活度（前，保留两位小数）
	 */
	//@ApiModelProperty(value = "出厂活度（前，保留两位小数）")
	private Float data1;

	/**
	 * 出厂活度（后）
	 */
	//@ApiModelProperty(value = "出厂活度（后）")
	private Integer data2;

	/**
	 * 活度测量日期
	 */
	//@ApiModelProperty(value = "活度测量日期")
	private Date measurementDate;
	// ************************************************ 含密封源装置


}
