package cn.smarthse.rho.modules.sys.model.e.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
public class EMachineRoomDetailVo implements Serializable{
	private static final long serialVersionUID = 8195400584960196168L;
	
	
	private Long id;

	private Long cid;

	/**
	 * 多地址id（b_company_address.id）
	 */
	private Long addrId;
	
	/**
	 * 机房名称
	 */
	private String name;
	
	/**
	 * 院区名称
	 */
	private String companyName;

	/**
	 * 执业地址名称
	 */
	private String addrName;

	/**
	 * 机房编号
	 */
	private String roomCode;

	/**
	 * 是否为车载机房（0-否；1-是）
	 */
	private Integer isOnboard;


	/**
	 * 工作场所级别(1-甲级；2-乙级；3-丙级)
	 */
	private Integer level;

	/**
	 * 启用状态(0-未启用；1-已启用)
	 */
	private Integer enableStatus;


	/**
	 * 放射诊疗类别(英文逗号分隔)(EdeviceDiagnosisTypeEnum)
	 */
	private String diagnosisType;

	/**
	 * 许可证状态(0-无；1-未许可；2-已许可)
	 */
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	private Integer licenseStatusType;

	/**
	 * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	 */
	private Integer warningStatus;


	/**
	 * 射线装置list
	 */
	private List<EMachineRoomDeviceVo> deviceList;

	/**
	 * 放射性同位素list
	 */
	private List<EMachineRoomSourceVo> sourceList;

}
