package cn.smarthse.rho.modules.sys.model.e.vo;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;


/**
 * 密封放射源-新增装置时直接选择设备-设备vo
 */
@Data
public class EDeviceRoomForSealedVo implements Serializable{
	@Serial
	private static final long serialVersionUID = 8668807808384305605L;

	/**
	 * 设备id
	 */
	private Long id;

	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	private Integer type;

	/**
	 * 设备名称
	 */
	private String name;

	/**
	 * 设备编号
	 */
	private String deviceNo;

	/**
	 * 射线装置类型id（sys_device_category）
	 */
	private Long category;

	/**
	 * 射线装置类型name
	 */
	private String categoryName;

	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	private Integer mobilityType;

	/**
	 * 设备所关联的场所
	 */
	private List<EMachineRoomListVo> machineRoomList;

}
