package cn.smarthse.rho.modules.sys.model.e.vo;

import cn.smarthse.rho.modules.sys.enums.license.LicenseChangeTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EDeviceLicenseOptLogVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 5412011571558773722L;


    /**
     * 时间
     */
    private LocalDate createDate;

    /**
     * 变更种类
     * LicenseChangeTypeEnum
     */
    private String subType;
    private String subTypeName;


    /**
     * 变更前状态
     */
    private Integer beforeStatus;

    /**
     * 变更后状态
     */
    private Integer afterStatus;

    /**
     * 操作类型（0-提交；1-确认；2-退回；3-终止）
     */
    private Integer type;

    /**
     * 操作人
     */
    private String optor;




    public String getSubTypeName() {
        if (subType == null) {
            return "";
        }
        return LicenseChangeTypeEnum.getNameBySubType(subType);
    }

}
