package cn.smarthse.rho.modules.sys.model.e.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 设备历史记录核素信息
 *
 * @author chuhy
 * @date 2024/5/31 14:10
 */
@Data
public class EDeviceHistorySourceVo implements Serializable{
	private static final long serialVersionUID = 1181219065111150724L;


	/**
	 * 核素名称
	 */
	//@ApiModelProperty(value = "核素名称")
	private String name;

	/**
	 * 编号
	 */
	//@ApiModelProperty(value = "编号")
	private String factoryNo;

	/**
	 * 生产厂家
	 */
	//@ApiModelProperty(value = "生产厂家")
	private String factory;

	/**
	 * 变更日期
	 */
	//@ApiModelProperty(value = "变更日期")
	private Date changeDate;


	// **********************密封放射源字段
	/**
	 * 出厂活度（前，保留两位小数）
	 */
	//@ApiModelProperty(value = "出厂活度（前，保留两位小数）")
	private Float sealedData1;

	/**
	 * 出厂活度（后）
	 */
	//@ApiModelProperty(value = "出厂活度（后）")
	private Integer sealedData2;

	/**
	 * 活度测量日期
	 */
	//@ApiModelProperty(value = "活度测量日期")
	private Date measurementDate;
	// **********************密封放射源字段


	// **********************非密封放射源字段
	/**
	 * 物理状态（1-固态；2-液态；3-气态）
	 */
	//@ApiModelProperty(value = "物理状态（1-固态；2-液态；3-气态）")
	private Integer physicalState;

	/**
	 * 最大等效日操作量(前，保留两位小数)
	 */
	//@ApiModelProperty(value = "最大等效日操作量(前，保留两位小数)")
	private Float nonSealedData1;

	/**
	 * 最大等效日操作量(后)
	 */
	//@ApiModelProperty(value = "最大等效日操作量(后)")
	private Integer nonSealedData2;

	/**
	 * 最大等效年操作量(前，保留两位小数)
	 */
	//@ApiModelProperty(value = "最大等效年操作量(前，保留两位小数)")
	private Float nonSealedData3;

	/**
	 * 最大等效年操作量(后)
	 */
	//@ApiModelProperty(value = "最大等效年操作量(后)")
	private Integer nonSealedData4;
	// **********************非密封放射源字段
}
