package cn.smarthse.rho.modules.sys.model.e.vo;

import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;


/**
 * 许可管理 - 设备列表
 */
@Data
public class EDeviceForLicenseVo implements Serializable{
	@Serial
	private static final long serialVersionUID = 5698032877069073392L;


	/**
	 * id
	 */
	@ExcelProperty(value = "ID(请勿修改)")
	private Long id;

	/**
	 * 名称
	 */
	@ExcelProperty(value = "设备名称")
	private String name;
	
	/**
	 * 设备编号
	 */
	@ExcelProperty(value = "设备编号")
	private String factoryNo;

	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	@ExcelIgnore
	private Integer type;
	@ExcelProperty(value = "设备类型")
	private String typeStr;

	/**
	 * 设备移动类型(1-固定设备；2-移动设备；3-车载设备)
	 */
	@ExcelIgnore
	private Integer mobilityType;
	/**
	 * 是否为床边机(0-否；1-是)（mobility_type为2时才有值）
	 */
	@ExcelIgnore
	private Integer isBedside;

	/**
	 * 许可状态(1-未许可；2-已许可；3-许可注销)
	 */
	@ExcelIgnore
	private Integer licenseStatus;
	@ExcelProperty(value = "许可状态")
	private String licenseStatusStr;



	public String getTypeStr() {
		if (type == null) return "";
		return EdeviceTypeEnum.getName(type);
	}

	public String getLicenseStatusStr() {
		if (licenseStatus == null) return "";
		return EdeviceLicenseStatusEnum.getNameByValue(licenseStatus);
	}

}
