package cn.smarthse.rho.modules.sys.model.e.param;

import cn.smarthse.rho.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;


@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EDeviceListParam extends PageParam implements Serializable  {
    private static final long serialVersionUID = -6349790842288319815L;


    /**
     * device.id
     */
    private Long id;

    /**
     * 场所id
     */
    private Long roomId;

    /**
     * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
     */
    //@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）")
    private Integer type;


    /**
     * 许可状态(1-未许可；2-已许可；3-许可注销)
     */
    //@ApiModelProperty(value = "许可状态(1-未许可；2-已许可；3-许可注销)")
    private Integer licenseStatus;

    /**
     * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
     */
    //@ApiModelProperty(value = "已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
    private Integer licenseStatusType;

    /**
     * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
     */
    //@ApiModelProperty(value = "预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)")
    private Integer warningStatus;

    /**
     * 异常信息状态(0-未完善；1-已完善)
     */
    private Integer informationStatus;


    /**
     * 状态（1-正常；2-暂停使用；3-退役/报废）
     */
    //@ApiModelProperty(value = "状态（1-正常；2-暂停使用；3-退役/报废）")
    private Integer status;


    /**
     * 核素种类
     */
    //@ApiModelProperty(value = "核素种类")
    private String nuclideName;

}
