package cn.smarthse.rho.modules.sys.model.e.param;

import lombok.Data;

import java.io.Serializable;

/**
 * 设备档案 - 基础信息
 */
@Data
public class EDeviceBaseDto implements Serializable{
	private static final long serialVersionUID = 9222711131300882818L;
	
	private Long id;

	/**
	 * 名称
	 */
	//@ApiModelProperty(value = "名称")
	private String name;
	
	/**
	 * 编号
	 */
	//@ApiModelProperty(value = "编号")
	private String factoryNo;
	
	/**
	 * 生产厂家
	 */
	//@ApiModelProperty(value = "生产厂家")
	private String factory;
	
	/**
	 * 状态（1-正常；2-暂停使用；3-退役/报废）
	 */
	//@ApiModelProperty(value = "状态（1-正常；2-暂停使用；3-退役/报废）")
	private Integer status;
	
	/**
	 * 类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）
	 */
	//@ApiModelProperty(value = "类型（1-射线装置；2-非密封放射性核素；3-密封放射源；4-含密封源装置）")
	private Integer type;
	
	/**
	 * (核素)用途
	 */
	//@ApiModelProperty(value = "(核素)用途")
	private String useTo;
	
	/**
	 * 所在机房/场所id
	 */
	//@ApiModelProperty(value = "所在机房/场所id")
	private Long locationId;

	/**
	 * 所在机房/场所name
	 */
	//@ApiModelProperty(value = "所在机房/场所name")
	private String locationName;
	
	/**
	 * 许可状态(1-未许可；2-已许可；3-许可注销)
	 */
	//@ApiModelProperty(value = "许可状态(1-未许可；2-已许可；3-许可注销)")
	private Integer licenseStatus;

	/**
	 * 已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)
	 */
	//@ApiModelProperty(value = "已许可状态类型(0-无；1-正常；2-校验即将到期；3-校验已过期) (licenseStatus=2时才会有)")
	private Integer licenseStatusType;

	/**
	 * 预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)
	 */
	//@ApiModelProperty(value = "预警状态(0-无；21-首次预警；22-黄色预警；31-红色预警；32-启动执法)")
	private Integer warningStatus;
	
	/**
	 * (装置)使用科室
	 */
	//@ApiModelProperty(value = "(装置)使用科室")
	private String useDepartmentId;

}
