package cn.smarthse.rho.modules.sys.model.d.param;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 佐证材料新增检测参数
 */
@Data
public class AddLocationCheckByMaterialsParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -5144988715839371862L;


    /**
     * 场所id
     */
    private Long locationId;

    /**
     * 所在场所
     */
    private String locationName;

    /**
     *医院id
     */
    private Long cid;

    /**
     * 检测机构名称
     */
    private String orgName;

    /**
     * 检测类型（1-控评检测；2-年度检测；）
     */
    private Integer type;

    /**
     * 检测时间
     */
    private Date checkTime;

    /**
     * 报告编号
     */
    private String reportNo;

    /**
     * 报告url(佐证材料提交文件)
     */
    private String reportUrl;

    /**
     * 检测结果：0-不合格；1-合格；
     */
    private Integer checkResult;

    private Long userId;


}
