package cn.smarthse.rho.modules.sys.model.d.param;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * 佐证材料新增检测参数
 */
@Data
public class AddDeviceCheckByMaterialsParam implements Serializable {
    @Serial
    private static final long serialVersionUID = -8798012467365839324L;

    /**
     * 设备id
     */
    private Long deviceId;

    /**
     * 医院id
     */
    private Long cid;


    /**
     * 检测机构名称
     */
    private String orgName;

    /**
     * 检测时间
     */
    private Date checkTime;

    /**
     * 检测类型（1-状态检测；2-验收检测；3-稳定性检测；）
     */
    private Integer type;

    /**
     * 报告编号
     */
    private String reportNo;

    /**
     * 报告url
     */
    private String reportUrl;

    /**
     * 检测结果：0-不合格；1-合格；
     */
    private Integer checkResult;

    private Long userId;

}
