package cn.smarthse.rho.modules.sys.model.c.vo.staffErr;

import cn.smarthse.rho.modules.sys.enums.err.StaffErrorEnum;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


@Data
@EqualsAndHashCode(callSuper = false)
public class StaffErrVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;


    private Long cid;

    private String companyName;


    private Long staffBaseInfoId;

    /**
     * 人员类型（0普通 1放射工作人员）
     */
    private Integer staffType;

    /**
     * 人员类型（0普通 1管理人员）
     */
    private Integer managerType;

    /**
     * 身份证 0正常 1空 2格式错误
     */
    private Integer idcardErr;
    private String idcardErrCn;

    /**
     * 手机号 0正常 1空 2格式错误
     */
    private Integer phoneErr;
    private String phoneErrCn;

    /**
     * 职业照射种类及代码 0正常 1空
     */
    private Integer raTypeErr;
    private String raTypeErrCn;

    /**
     * 岗位 0正常 1空
     */
    private Integer postErr;
    private String postErrCn;

    /**
     * 岗位状态 0正常 1空
     */
    private Integer postStatusErr;
    private String postStatusErrCn;

    /**
     * 机构 0正常 1空
     */
    private Integer orgErr;
    private String orgErrCn;

    /**
     * 工作经历 0正常 1空 2岗位状态为“离岗”，但最近一条工作经历中未填写离岗时间
     */
    private Integer weErr;
    private String weErrCn;

    /**
     * 成为放射工作人员时间 0正常 1空
     */
    private Integer rayStaffTimeErr;
    private String rayStaffTimeErrCn;


    public String getIdcardErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.ID_CARD, idcardErr);
    }

    public String getPhoneErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.PHONE, phoneErr);
    }

    public String getRaTypeErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.RA_TYPE, raTypeErr);
    }

    public String getPostErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.POST, postErr);
    }

    public String getPostStatusErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.POST_STATUS, postStatusErr);
    }

    public String getOrgErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.ORG, orgErr);
    }

    public String getWeErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.WE, weErr);
    }
    public String getRayStaffTimeErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.RAY_STAFF_TIME, rayStaffTimeErr);
    }
}
