package cn.smarthse.rho.modules.sys.model.c.vo.staff;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * 人员待迁移列表
 * </p>
 *
 * @author author
 * @since 2025-11-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StaffRelocationVo  implements Serializable {

    private static final long serialVersionUID = -2928647934957567488L;


    private Long id;

    /**
     * 人员基础信息id
     */
    private Long staffBaseInfoId;

    /**
     * 迁移前单位id
     */
    private Long beCid;

    /**
     * 迁移目标单位id
     */
    private Long toCid;

    //人员姓名
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    //身份证
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //性别 0-女；1-男
    private Integer sex;

    //年龄
    private Integer age;

    //所属部门科室
    private Long orgId;
    //所属部门科室名称
    private Long orgName;

    //当前所在院区
    private Long beCompanyName;
    //迁移目标院区
    private Long toCompanyName;


}
