package cn.smarthse.rho.modules.sys.model.c.vo.staff;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 许可变更操作记录
 * </p>
 *
 * @author author
 * @since 2025-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("c_staff_relocation_log")
public class StaffRelocationLogVo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1471481546163587182L;

    private Long id;

    /**
     * 人员id
     */
    private Long staffBaseInfoId;

    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    /**
     * 迁出院区id
     */
    private Long beCid;
    private String beCompanyName;

    /**
     * 迁入cid
     */
    private Long toCid;
    private String toCompanyName;

    /**
     * 操作时间
     */
    private LocalDateTime optTime;

    /**
     * 操作人id
     */
    private Long optId;

    /**
     * 操作人
     */
    private String optor;

    /**
     * 操作类型 1迁入 2迁出
     */
    private String optType;



}
