package cn.smarthse.rho.modules.sys.model.c.vo.rayCert;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * <p>
 * 放射工作人员证，生成之后的信息
 * </p>
 *
 * @author chenliang
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class RayCertAfterGenVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;
    private String scode;

    //@ApiModelProperty(value = "放射人员工作证编码")
    private String raCert;

    //@ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    //@ApiModelProperty(value = "姓名")
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    //@ApiModelProperty(value = "出生日期(来自身份证)")
    private LocalDate birthday;

    //@ApiModelProperty(value = "性别 0-女；1-男（来自身份证）")
    private Integer sex;

    //@ApiModelProperty(value = "头像id")
//    private Long headId;

    //@ApiModelProperty(value = "头像链接")
    private String headUrl;

    //@ApiModelProperty(value = "体检时间")
    private LocalDate healthCheckTime;

    //@ApiModelProperty(value = "个人剂量监测时间")
    private LocalDate doseCheckTime;

    private LocalDate doseBeginTime;
    private LocalDate doseEndTime;

    //@ApiModelProperty(value = "培训时间")
    private LocalDate trainingTime;

    //@ApiModelProperty(value = "工作单位名称")
    private String cname;

    //@ApiModelProperty(value = "发证单位名称")
    private String issueUnitName;

    //@ApiModelProperty(value = "发证时间")
    private LocalDate issueTime;

    private Integer isComplete;
}
