package cn.smarthse.rho.modules.sys.model.c.vo.experience;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * <p>
 * 员工：工作经历
 * </p>
 *
 * @author chenliang
 * @since 2024-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StaffWorkExperienceRecordVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //id
    private Long id;

    //工作经历id
    private Long experienceId;

    //cid
    private Long cid;
    //执业地址id
    private Long subCid;

    private String companyName;

    //部门id
    private Long orgId;
    //执业地址名称
    private String businessAddressName;
    //部门名称
    private String orgName;

    private Long staffBaseInfoId;

    //岗位/工种
    private Long post;

    //岗位/工种
    private String postName;

    //职业照射种类及代码
    private String raType;

    //@ApiModelProperty(value = "上岗时间")
    private LocalDateTime postStartTime;

    //@ApiModelProperty(value = "离岗时间")
    private LocalDateTime postDepartureTime;

    //@ApiModelProperty(value = "暂时离岗时间")
    private LocalDateTime tpPostDepartureTime;

    //编辑类型（1新增 2编辑 3删除）
    private Integer editType;

    //编辑时间
    private LocalDateTime editTime;
    //编辑人
    private Long editorId;
    //编辑人
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String editorName;

    //多执业地址
    private CompanyAddressVo companyAddressVo;

}
