package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StaffSelectInfo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private Long id;

    //@ApiModelProperty(value = "姓名")
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    //@ApiModelProperty(value = "手机号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String phone;

    //@ApiModelProperty(value = "身份证类型")
    private String idcardType;

    //@ApiModelProperty(value = "身份证")
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //@ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    //@ApiModelProperty(value = "年龄")
    private Integer age;

    //@ApiModelProperty(value = "出生日期")
    private LocalDate birthday;

    //成为放射工作人员时间
    private LocalDateTime rayStaffTime;

    //职业照射种类及代码
    private String raType;

    //头像
    private Long headId;
    //头像文件名称
    private String headFileName;
    //头像路径
    private String headFileUrl;

    //搜索结果
    //1您搜索的证件号：xxx，尚未在“放射卫生在线”中，可点击下方按钮进行添加
    //2您搜索的证件号：xxx，已在“放射卫生在线”中，点击下方添加到本院区
    //3您搜索的证件号：xxx，已在本院区中，无需重复添加
    private Integer sr;
}
