package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * <p>
 * 人员列表-迁移以哦你
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StaffListRlVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //人员基础信息id
    private Long id;

    //院区id
    private Long cid;

    //人员公司关联id
    private Long staffId;

    //部门id
    private Long orgId;

    //部门名称
    private String orgName;

    //岗位状态
    private Integer postStatus;

    //姓名
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String name;

    //身份证 这个身份证要手动脱敏
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idcard;

    //性别 0-女；1-男
    private Integer sex;

    //出生日期
    private LocalDate birthday;

    //年龄
    private Integer age;




}
