package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;




/**
 * <p>
 * 放射卫生防护管理人员列表
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="放射卫生防护管理人员选择列表", description="放射卫生防护管理人员选择列表")
public class StaffChooseListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty(value = "人员基础信息id")
    private Long id;

    //@ApiModelProperty(value = "人员id")
    private Long staffId;

    //@ApiModelProperty(value = "姓名")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty(value = "身份证号")
    @Desensitization(type = DesensitizationType.ID_CARD)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idCard;

    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    private Integer age;

    private Integer sex;

    private String orgName;

}
