package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;



@Data
@EqualsAndHashCode(callSuper = false)
//@ApiModel(value = "人员绑定证书的证书选择列表", description = "人员绑定证书的证书选择列表")
public class StaffCertChooseListVo extends PageParam implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("证书id")
    private Long certId;

    //@ApiModelProperty("公司id")
    private Long cid;

    //@ApiModelProperty("人员基础信息id")
    private Long staffBaseInfoId;

    //@ApiModelProperty(value = "员工姓名")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String staffName;

    //@ApiModelProperty(value = "机构id")
    private Long techId;

    //@ApiModelProperty(value = "机构名称")
    private String techName;

    //@ApiModelProperty(value = "证书类型：1-放射卫生防护管理人员培训证； 2-放射防护培训合格证")
    private Integer certType;

    //@ApiModelProperty(value = "证书编号")
    private String certNo;

    //@ApiModelProperty(value = "取证日期")
    private LocalDate issuanceDate;

    //@ApiModelProperty(value = "复审日期")
    private LocalDate reviewDate;

    //@ApiModelProperty(value = "证书有效期")
    private LocalDate certValidDate;

    //@ApiModelProperty(value = "培训名称")
    private String trainingName;

    //@ApiModelProperty(value = "培训类型：培训类型：1-初训；2-复训；3岗前培训；4岗中培训")
    private String trainingType;

    //@ApiModelProperty(value = "证书附件id")
    private Long certFileId;

    //@ApiModelProperty(value = "证书附件url")
    private String certFileUrl;

    //@ApiModelProperty(value = "附件名称")
    private String certFileName;

}
