package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.modules.sys.enums.err.StaffErrorEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;




/**
 * <p>
 * 放射卫生防护管理人员列表
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="放射卫生防护管理人员列表", description="放射卫生防护管理人员列表")
public class RayStaffListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    //@ApiModelProperty(value = "人员id")
    private Long staffId;

    //@ApiModelProperty(value = "手机号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    /**
     * 手机号 0正常 1空 2格式错误
     */
    private Integer phoneErr;
    private String phoneErrCn;

    //@ApiModelProperty(value = "姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty(value = "管理人员岗位状态（0离岗 1在岗）")
    private Integer managerPostStatus;

    //管理人员类型（0普通 1首页展示）
    private Integer managerMainType;

    //@ApiModelProperty(value = "岗位状态")
    private String postStatus;

    //@ApiModelProperty(value = "数据来源（1同步 2单位新增）")
    private Integer dataSource;

    //@ApiModelProperty(value = "人员类型（0非放射工作人员 1放射工作人员）")
    private Integer staffType;

    //@ApiModelProperty(value = "证书是否有效（0无效 1有效）")
    private Integer certValid;

    //@ApiModelProperty(value = "时间阈值")
    private LocalDateTime thresholdTime;

    public void desensitizeNameTotal(){
        this.genName();
        this.genPhone();
    }

    public void genName() {
        this.name = DesensitizationUtils.desensitized(name, DesensitizationType.NAME);
    }
    public void genPhone() {
        this.phone = DesensitizationUtils.desensitized(phone, DesensitizationType.MOBILE_PHONE);
    }

    public String getPhoneErrCn() {
        return StaffErrorEnum.getCn(StaffErrorEnum.PHONE, phoneErr);
    }
}
