package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;




/**
 * <p>
 * 组织机构-人员列表
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="组织机构-人员列表vo", description="组织机构-人员列表vo")
public class OrgStaffListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("人员基础信息id）")
    private Long id;

    //@ApiModelProperty("人员id）")
    private Long staffId;

    //@ApiModelProperty(value = "姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty(value = "工号")
    private String workNo;

    //@ApiModelProperty(value = "工号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idcard;

    //@ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    //@ApiModelProperty(value = "年龄")
    private Integer age;

    //@ApiModelProperty(value = "岗位/工种")
    private String post;

    //@ApiModelProperty(value = "岗位/工种")
    private String postName;

    public void genAll(){
        this.genSexAndAge();
        this.desensitizeNameTotal();
    }

    public void genSexAndAge(){
        this.genSex();
        this.genAge();
    }
    public void desensitizeNameTotal(){
        this.genName();
        this.genIdcard();
    }

    public void genName() {
        this.name = DesensitizationUtils.desensitized(name, DesensitizationType.NAME);
    }

    public void genSex() {
        if(sex == null && IdcardUtil.isValidCard(idcard)){
            this.sex =  IdcardUtil.getGenderByIdCard(idcard);
        }
    }

    public void genAge() {
        if(age == null && IdcardUtil.isValidCard(idcard)){
            this.age =  IdcardUtil.getAgeByIdCard(idcard);
        }
    }
    public void genIdcard() {
        this.idcard = DesensitizationUtils.desensitized(idcard, DesensitizationType.ID_CARD);
    }


}
