package cn.smarthse.rho.modules.sys.model.c.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * <p>
 * 医院：放射诊疗许可证Vo
 * </p>
 *
 * @author chenliang
 * @since 2024-03-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="放射工作人员工作证要求vo", description="放射工作人员工作证要求vo")
public class CertConditionVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long staffBaseInfoId;

    //@ApiModelProperty("0无；1有")
    private Integer profilePictureInfo = 0;

    //@ApiModelProperty("-1缺少有效期内数据 0体检结果异常 1资料完整")
    private Integer healthCheckInfo = -1;

    //@ApiModelProperty("职业健康体检结果")
    private String healthCheckResult;

    //@ApiModelProperty("-1缺少有效期内数据；0不合格；1合格")
    private Integer trainingInfo = -1;

    // 1 有同有效步数据，无论手动上传的资料处于什么状态，显示“资料已完整”
    //-1 无有效同步数据，且无佐证材料：显示“缺有效期内个人剂量监测结果、点击补充“
    //23 无有效同步数据，佐证材料被退回，显示“个人剂量监测证明被退回、重新提交”
    //22 无有效同步数据，佐证材料审核已通过，显示“资料已完整、查看资料”（这里要和1分开，用22，是因为要求有查看资料按钮）
    //21 无有效同步数据，佐证材料待审核，显示“审核中、查看资料”
    private Integer doseInfo = -1;

    private Long doseDataId;




    private LocalDate healthCheckTime;
    private LocalDate doseCheckTime;
    private LocalDate doseBeginTime;
    private LocalDate doseEndTime;

    private LocalDate trainingTime;

    //@ApiModelProperty("资料：0不完整，1完整")
    private Integer isComplete;
    public Integer getIsComplete() {
        return isComplete != null ? isComplete : profilePictureInfo == 1 && healthCheckInfo == 1 && trainingInfo == 1 && (doseInfo == 1 || doseInfo == 22) ? 1 : 0;
    }


}
