package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.rho.modules.sys.model.staffArchives.vo.StaffCompanyVo;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

//@ApiModel(value = "个人剂量监测人员详情vo", description = "医院：个人剂量监测人员详情vo")
@Data
public class CDoseDataVo implements Serializable {

    //@ApiModelProperty("ID")
    private Long id;

    //@ApiModelProperty("cid")
    private Long cid;

    //@ApiModelProperty("主表ID")
    private Long baseId;

    //@ApiModelProperty("员工id")
    private Long staffId;

    //@ApiModelProperty("姓名")
    private String name;

    //@ApiModelProperty("身份证")
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //@ApiModelProperty("性别 0-女；1-男")
    private Integer sex;

    //@ApiModelProperty("年龄")
    private Integer age;

    //@ApiModelProperty("岗位/工种")
    private String post;

    //@ApiModelProperty("射线类型")
    private String raType;

    //@ApiModelProperty("职业照射种类及代码")
    private String exposureType;

    //@ApiModelProperty("监测机构id")
    private Long techId;

    //@ApiModelProperty("监测机构名称")
    private String techName;

    //@ApiModelProperty("时间")
    private LocalDate checkDate;

    //@ApiModelProperty("监测周期：开始")
    private LocalDate beginDate;

    //@ApiModelProperty("监测周期：结束")
    private LocalDate endDate;

    //@ApiModelProperty("监测结果")
    private String result;

    //@ApiModelProperty("年度剂量结果")
    private String doseResult;

    //@ApiModelProperty("超剂量调查报告")
    private String bigDoseReport;

    //@ApiModelProperty("是否超剂量")
    private Boolean isBigDose;

    //@ApiModelProperty("超剂量调查状态 ")
    private String investigateStatus;

    //@ApiModelProperty("报告编号")
    private String reportNo;

    //@ApiModelProperty("报告地址")
    private String reportUrl;

    //@ApiModelProperty("报告名称")
    private String reportName;

    //@ApiModelProperty("公司信息")
    private StaffCompanyVo staffCompanyVo;

    //@ApiModelProperty("超剂量调查报告名称")
    private String bigDoseReportName;

}
