package cn.smarthse.rho.modules.sys.model.c.vo;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;



/**
 * <p>
 * 员工：证书 vo
 * </p>
 *
 * @author chenliang
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="CCertVo", description="CCertVo")
public class CCertVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    //@ApiModelProperty(value = "人员基础信息id")
    private Long baseId;

    //@ApiModelProperty("地市简称")
    private String cityShortNamePy;

    //@ApiModelProperty("县区简称")
    private String areaShortNamePy;

    //@ApiModelProperty("流水号年份")
    private Integer serialYear;

    //@ApiModelProperty("流水号")
    private Integer serialNo;

    //@ApiModelProperty(value = "放射人员工作证编码")
    private String raCert;

    //@ApiModelProperty(value = "放射人员工作证链接")
    private String raCertUrl;

    //@ApiModelProperty(value = "放射人员工作证文件id")
    private Long raCertFileId;

    //@ApiModelProperty(value = "职业照射种类及代码")
    private String raType;

    //@ApiModelProperty(value = "姓名")
    private String name;

    //@ApiModelProperty(value = "身份证")
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //@ApiModelProperty(value = "出生日期(来自身份证)")
    private LocalDate birthday;

    //@ApiModelProperty(value = "性别 0-女；1-男（来自身份证）")
    private Integer sex;

    //@ApiModelProperty(value = "头像id")
    private Long headId;

    //@ApiModelProperty(value = "头像链接")
    private String headUrl;

    //@ApiModelProperty(value = "体检时间")
    private LocalDate healthCheckTime;

    //@ApiModelProperty(value = "个人剂量监测时间")
    private LocalDate doseCheckTime;
    private LocalDate doseBeginTime;
    private LocalDate doseEndTime;

    //@ApiModelProperty(value = "培训时间")
    private LocalDate trainingTime;

    //@ApiModelProperty(value = "工作单位id")
    private Long cid;

    //@ApiModelProperty(value = "工作单位id")
    private String cname;

    //@ApiModelProperty(value = "发证单位id")
    private Long issueUnitId;

    //@ApiModelProperty(value = "发证单位名称")
    private String issueUnitName;

    //@ApiModelProperty(value = "发证时间")
    private LocalDate issueTime;

    //@ApiModelProperty(value = "更新时间")
    private LocalDateTime editTime;
}
