package cn.smarthse.rho.modules.sys.model.c.param;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TrainingOfflineCertSyncParam extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;


    //@ApiModelProperty(value = "姓名")
    private String name;

    //@ApiModelProperty(value = "身份证")
    private String idCard;

    private String rhoIdCardType;

    private Integer sex;

    private LocalDate birthday;

    //@ApiModelProperty(value = "培训系统培训id")
    private Long sourceTrainingId;

    //@ApiModelProperty(value = "培训系统报名id")
    private Long sourceEnrollId;

    //@ApiModelProperty(value = "培训系统证书id")
    private Long sourceCertId;

    //@ApiModelProperty(value = "培训系统人员id")
    private Long sourceStaffId;

    //@ApiModelProperty(value = "医院id")
    private Long cid;

    //@ApiModelProperty(value = "机构id")
    private Long techId;

    //@ApiModelProperty(value = "机构名称")
    private String techName;

    //@ApiModelProperty(value = "证书类型：1-放射卫生防护管理人员培训证； 2-放射防护培训合格证")
    private Integer certType;

    //@ApiModelProperty(value = "证书编号")
    private String certNo;

    //@ApiModelProperty(value = "取证日期")
    private LocalDate issuanceDate;

    //@ApiModelProperty(value = "证书有效期")
    private LocalDateTime certValidDate;

    //@ApiModelProperty(value = "培训名称")
    private String trainingName;

    //@ApiModelProperty(value = "培训开始时间")
    private LocalDate trainingBeginDate;

    //@ApiModelProperty(value = "培训结束时间")
    private LocalDate trainingEndDate;

    //@ApiModelProperty(value = "培训类型：1-初训；2-复训")
    private String trainingType;

    //@ApiModelProperty(value = "考核结果（0不合格，1合格）")
    private Integer result;

    //@ApiModelProperty(value = "培训内容")
    private String trainingContent;

    //@ApiModelProperty(value = "培训学时")
    private String trainingHours;





    //@ApiModelProperty(value = "OSS路径地址（相对）")
    private String ossUrl;

    //@ApiModelProperty(value = "培训系统文件id")
    private Long sourceFileId;

    //@ApiModelProperty(value = "附件名")
    private String fileName;

    //@ApiModelProperty(value = "附件大小")
    private Long fileSize;

    //@ApiModelProperty(value = "附件扩展名（可用于图标展示）")
    private String fileExt;

    //@ApiModelProperty(value = "附件Hash")
    private String fileHash;

    //@ApiModelProperty(value = "上传IP")
    private String creatorIp;

}
