package cn.smarthse.rho.modules.sys.model.c.param;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@EqualsAndHashCode(callSuper = false)
@Data
public class StaffChangeLogParam extends PageParam implements Serializable {

    private static final long serialVersionUID = -1L;

    //@ApiModelProperty(value = "数据id（staff_base_info_id, staff_id）")
    private String dataIdsStr;

    //@ApiModelProperty(value = "数据id（staff_base_info_id, staff_id）", hidden = true)
    private List<Long> dataIds;

    //@ApiModelProperty(value = "表名", hidden = true)
    private List<String> tableNames = CollUtil.toList("c_staff_base_info", "c_staff");

    //@ApiModelProperty(value = "字段名", hidden = true)
    private List<String> fieldValues;

    //@ApiModelProperty(value = "字段名")
    private String fieldValuesStr;

    public List<Long> getDataIds() {
        return CollUtil.isEmpty(dataIds) && StrUtil.isNotEmpty(dataIdsStr) ? StrUtil.split(dataIdsStr, ",").stream().map(v->Long.valueOf(v)).collect(Collectors.toList()) : dataIds ;
    }

    public List<String> getFieldValues() {
        return CollUtil.isEmpty(fieldValues) && StrUtil.isNotEmpty(fieldValuesStr) ? StrUtil.split(fieldValuesStr, ",") : fieldValues ;
    }
}
