package cn.smarthse.rho.modules.sys.model.bind.vo;


import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import lombok.Data;

import java.io.Serializable;

@Data
public class SysUserBindLogVo extends BaseEntity implements Serializable{

    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long cid;

    /**
     * 账号id
     * 用户表id
     */
    private Long userId;

    /**
     * 绑定联系人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String bindName;

    /**
     * 绑定手机号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String bindTel;

    /**
     * 系统来源,UserSystemWideEnum
     */
    private Integer systemSource;

    /**
     * 记录类型，UserBindLogTypeEnum
     */
    private Integer type;

    /**
     * 审核状态 0无需审核 ，1通过， 2退回
     */
    private Byte auditState;

    /**
     * 佐证材料id
     */
    private Long evidenceId;

    private String  evidenceFileName;

    private String  evidenceFileUrl;

    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String createUserName;

}
