package cn.smarthse.rho.modules.sys.model.bind.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Accessors(chain = true)
public class SysUserBindCompanyVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 号码绑定的user_id
     */
    private Long userId;
    /**
     * 企业id
     */
    private Long cid;
    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 绑定时间
     */
    private LocalDateTime bindTime;

    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String bindName;
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String bindTel;

    private Byte isFocus;

}
