package cn.smarthse.rho.modules.sys.model.bind.vo;

import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Accessors(chain = true)
public class ContactRebindHistoryVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * sys_user_bind_log_id
     */
    private Long id;

    /**
     * 操作账号
     */
    private String operatorName;

    /**
     * 操作时间
     */
    private LocalDateTime operatorTime;

    /**
     * 操作项
     */
    private String operatorType;

    /**
     * evidence fileName
     */
    private String evidenceFileName;
    private String evidenceFileUrl;

    @Desensitization(type = DesensitizationType.NAME)
    private String bindName;
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String bindTel;

    /**
     * 审核结果
     */
    private String auditResult;
}
