package cn.smarthse.rho.modules.sys.model.bind.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.modules.sys.enums.bind.ContactBindAuditStatusEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@Accessors(chain = true)
public class ContactRebindAppealListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 当前联系人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String currentContactName;

    /**
     * 当前联系人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String currentContactPhone;


    /**
     * 新联系人姓名
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.NAME)
    private String newContactName;

    /**
     * 新联系人电话
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String newContactPhone;

    /**
     * 佐证材料ID，对应 sys_file 表主键
     */
    private Long evidenceId;

    /**
     * 提交时间
     */
    private Date submitTime;

    /**
     * ContactBindAuditStatusEnum
     */
    private Integer auditStatus;

    /**
     * 系统范围（参考 UserSystemWideEnum）
     */
    private Integer systemWide;

    private String companyTypeName;
    // 院区名称
    private String companyName;
    // 机构名称
    private String hospitalName;
    private String creditCode;
    private String fileName;
    private String evidenceUrl;

    private String currentContactInfo;
    private String newContactInfo;
    private String auditStatusStr;

    public String getAuditStatusStr(){
           return ContactBindAuditStatusEnum.getName(auditStatus);
    }

    public String getCurrentContactInfo() {
        String name = DesensitizationUtils.desensitized(currentContactName, DesensitizationType.NAME);
        String phone = DesensitizationUtils.desensitized(currentContactPhone, DesensitizationType.MOBILE_PHONE);
        return (name != null ? name : "") + "/" + (phone != null ? phone : "");
    }

    public String getNewContactInfo() {
        String name = DesensitizationUtils.desensitized(newContactName, DesensitizationType.NAME);
        String phone = DesensitizationUtils.desensitized(newContactPhone, DesensitizationType.MOBILE_PHONE);
        return (name != null ? name : "") + "/" + (phone != null ? phone : "");
    }


}
