package cn.smarthse.rho.modules.sys.model.bind.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Accessors(chain = true)
public class AbnormalContactListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * sys_user_bind.id
     */
    private Long id;

    /**
     * 存疑手机号
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    private String bindTel;

    /**
     * 绑定企业数量
     */
    private Integer bindCount;

    /**
     * 绑定企业名称
     */
    private String bindCompany;

    /**
     * 是否重点关注：0-否，1-是
     */
    private Byte isFocus;
}
