package cn.smarthse.rho.modules.sys.model.bind.param;

import jakarta.validation.constraints.NotNull;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

@Data
public class ContactRebindStatusParam implements Serializable {

    private static final long serialVersionUID = 1L;
    @NotNull(message = "换绑申请id不能为空")
    private Long id;

    @NotNull(message = "审核状态不能为空")
    @Range(min = 1,max = 2, message = "审核状态不合法")
    private Integer auditStatus;// 1-通过 2-退回

    private Long userId;
    private Long currentUserId;
    private Long cid;
}
