package cn.smarthse.rho.modules.sys.model.b.vo.license;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;



/**
 * <p>
 * 许可校验表列表
 * </p>
 *
 * @author chenliang
 * @since 2024-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChangeLicenseListVo extends BaseEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = -3199371451144445756L;

    /**
     * 许可id
     */
    private Long id;


    /**
     * 公司id
     */
    private Long cid;

    /**
     * 基本类型（基础信息、设备 LicenseChangeTypeEnum）
     */
    private String type;

    /**
     * 具体许可类型（LicenseChangeTypeEnum）
     */
    private String subType;

    /**
     * 标题
     */
    private String title;

    /**
     * 业务id(公司id 或者 设备id)
     */
    private Long targetId;

    /**
     * 许可状态（LicenseStatusEnum）
     */
    private Integer adminLicenseStatus;

    /**
     * 监管确认时间
     */
    private LocalDateTime adminLicenseTime;

    /**
     * 监管id
     */
    private Long adminLicenseId;

    /**
     * 退回理由
     */
    private String returnReason;

    /**
     * 许可生成时间
     */
    private LocalDateTime genTime;

    /**
     * 佐证材料文件id
     */
    private Long sdFileId;

    /**
     * 佐证材料url
     */
    private String sdFileUrl;

    /**
     * 操作日志
     */
    private List<LicenseOptLogVo> optLogList;

}
