package cn.smarthse.rho.modules.sys.model.b.vo.license;

import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


/**
 * 许可详情
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChangeLicenseDetailVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -1392332817061498939L;

    /**
     * 许可id
     */
    private Long id;


    /**
     * 公司id
     */
    private Long cid;

    /**
     * 基本类型（基础信息、设备 LicenseChangeTypeEnum）
     */
    private String type;

    /**
     * 具体许可类型（LicenseChangeTypeEnum）
     */
    private String subType;

    /**
     * 标题
     */
    private String title;

    /**
     * 业务id(公司id 或者 设备id)
     */
    private Long targetId;

    /**
     * 许可状态（LicenseStatusEnum）
     */
    private Integer adminLicenseStatus;

    /**
     * 监管确认时间
     */
    private LocalDateTime adminLicenseTime;

    /**
     * 监管id
     */
    private Long adminLicenseId;

    /**
     * 许可生成时间
     */
    private LocalDateTime genTime;

    /**
     * 佐证材料文件id
     */
    private Long sdFileId;

    /**
     * 佐证材料url
     */
    private String sdFileUrl;

    /**
     * 设备id
     */
    private Long deviceId;
    /**
     *  设备名称
     */
    private String deviceName;
    /**
     *  设备类型
     */
    private Integer deviceType;
    /**
     *  设备编号
     */
    private String deviceFactoryNo;
    /**
     * 设备最后检查时间
     */
    private Date lastCheckTime;
    /**
     *  所在场所名称
     */
    private String locationName;
    /**
     *  设备变更关系
     *  不想写vo了，直接用这个
     */
    private List<ERelationDto> licenseDeviceRelationList;


    /**
     * 操作日志
     */
    private List<LicenseOptLogVo> optLogList;

}
