package cn.smarthse.rho.modules.sys.model.b.vo.hse.training;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 放射卫生企业信息
 * @TableName company
 */
@Accessors(chain = true)
@Data
public class RhoCompanyHseTrainingVo implements Serializable {

//    @ApiModelProperty("ID")
    private Long id;

    //@ApiModelProperty("放射用户id")
    private Long rhoUserId;

    //@ApiModelProperty("培训用户id")
    private Long trainUserId;

//    @ApiModelProperty("企业名称")
    private String name;

//    @ApiModelProperty("账号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

//    @ApiModelProperty("统一社会信用代码")
    private String unifiedSocialCc;

//    @ApiModelProperty("地址")
    private Long areaId;

//    @ApiModelProperty("地址")
    private String detailAreaName;

//    @ApiModelProperty("营业状态（1-正常 2-暂停营业 0-关闭）")
    private Integer businessState;

//    @ApiModelProperty("营业状态")
    private String businessStateName;

//    @ApiModelProperty("是否是测试企业")
    private Boolean isTest;

    /**
     * 是否禁用
     */
    private Boolean isForbidden;

    //来源(0放射卫生 5培训)
    private Integer virtuallyDataSource;
    //来源(放射卫生 培训)
    private String virtuallyDataSourceName;

}