package cn.smarthse.rho.modules.sys.model.b.vo.company.err;

import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.enums.err.CompanyErrorEnum;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
public class CompanyErrorVo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long cid;

    /**
     * 信息状态
     */
    private Integer informationStatus;
    /**
     * 医院名称 0正常 1空
     */
    private Integer hospitalNameErr;
    private String hospitalNameErrCn;

    /**
     * 院区名称 0正常 1空
     */
    private Integer nameErr;
    private String nameErrCn;

    /**
     * 信用代码 0正常 1空 2格式错误
     */
    private Integer creditCodeErr;
    private String creditCodeErrCn;

    /**
     * 唯一码（0正常 1空）
     */
    private Integer medicalNucodeErr;
    private String medicalNucodeErrCn;

    /**
     * 机构类别 0正常 1空 2机构类别为“诊所”，但未选择“是否口腔诊所”
     */
    private Integer typeErr;
    private String typeErrCn;

    /**
     * 床位数 0正常 1空
     */
    private Integer floorNumErr;
    private String floorNumErrCn;

    /**
     * 注册地址 0正常 1空 2未精确到街道一级
     */
    private Integer registeredAreaIdErr;
    private String registeredAreaIdErrCn;

    /**
     * 注册地址_详情 0正常 1空
     */
    private Integer registeredAddressErr;
    private String registeredAddressErrCn;

    /**
     * 执业地址 0正常 1空 2未精确到街道一级
     */
    private Integer areaIdErr;
    private String areaIdErrCn;

    /**
     * 执业地址_详情 0正常 1空
     */
    private Integer addressErr;
    private String addressErrCn;

    /**
     * 法定代表人_姓名 0正常 1空
     */
    private Integer legalNameErr;
    private String legalNameErrCn;

    /**
     * 法定代表人_手机 0正常 1空 2格式错误
     */
    private Integer legalTelErr;
    private String legalTelErrCn;

    /**
     * 主要负责人_姓名 0正常 1空
     */
    private Integer mainLeaderNameErr;
    private String mainLeaderNameErrCn;

    /**
     * 主要负责人_手机 0正常 1空 2格式错误
     */
    private Integer mainLeaderTelErr;
    private String mainLeaderTelErrCn;

    /**
     * 组织架构（0正常 1组织架构为空）
     */
    private Integer orgErr;
    private String orgErrCn;

    /**
     * 放射人员：0正常 1人员列表为空
     */
    private Integer staffRay;
    private String staffRayCn;

    /**
     * 放射人员_在岗情况：0正常 1存在放射人员但不是上岗状态
     */
    private Integer staffRayOnPost;
    private String staffRayOnPostCn;

    /**
     * 放射防护管理领导小组_机构名称(0正常 1领导机构名称为空)
     */
    private Integer rayGroupOrgNameErr;
    private String rayGroupOrgNameErrCn;

    /**
     * 放射防护管理领导小组_部门名称(0正常 1部门名称为空)
     */
    private Integer rayGroupDepartmentNameErr;
    private String rayGroupDepartmentNameErrCn;

    /**
     * 放射防护管理领导小组_成立文件(0正常 1成立文件为空)
     */
    private Integer rayGroupFoundingFileErr;
    private String rayGroupFoundingFileErrCn;


    /**
     * 放射管理人员列表（0正常 列表为空）
     */
    private Integer managerErr;
    private String managerErrCn;

    /**
     * 放射管理人员列表_手机号（0正常 1空 2格式不正确）
     */
    private Integer managerPhoneErr;
    private String managerPhoneErrCn;
    /**
     * 放射管理人员列表_手机号_格式（0正常 1格式不正确）
     */
    private Integer managerPhoneFormatErr;
    private String managerPhoneFormatErrCn;

    /**
     * 机房（0-正常；1-空；2-已启用场所数为0）
     */
    private Integer eMachineRoomErr;
    private String eMachineRoomErrCn;

    /**
     * 装置/同位素（0-正常；1-存在异常）
     */
    private Integer eDeviceErr;
    private String eDeviceErrCn;


    public String getHospitalNameErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.HOSPITAL_NAME_ERR, hospitalNameErr);
    }
    public String getNameErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.NAME_ERR, nameErr);
    }
    public String getCreditCodeErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.CREDIT_CODE_ERR, creditCodeErr);
    }
    public String getMedicalNucodeErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.MEDICAL_NUCODE_ERR, medicalNucodeErr);
    }
    public String getTypeErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.TYPE_ERR, typeErr);
    }
    public String getFloorNumErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.FLOOR_NUM_ERR, floorNumErr);
    }
    public String getRegisteredAreaIdErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.REGISTERED_AREA_ID_ERR, registeredAreaIdErr);
    }
    public String getRegisteredAddressErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.REGISTERED_ADDRESS_ERR, registeredAddressErr);
    }
    public String getAreaIdErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.AREA_ID_ERR, areaIdErr);
    }
    public String getAddressErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.ADDRESS_ERR, addressErr);
    }
    public String getLegalNameErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.LEGAL_NAME_ERR, legalNameErr);
    }
    public String getLegalTelErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.LEGAL_TEL_ERR, legalTelErr);
    }
    public String getMainLeaderNameErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.MAIN_LEADER_NAME_ERR, mainLeaderNameErr);
    }
    public String getMainLeaderTelErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.MAIN_LEADER_TEL_ERR, mainLeaderTelErr);
    }
    public String getOrgErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.ORG_ERR, orgErr);
    }
    public String getStaffRayCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.STAFF_RAY_ERR, staffRay);
    }
    public String getStaffRayOnPostCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.STAFF_RAY_ON_POST_ERR, staffRayOnPost);
    }
    public String getManagerErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.MANAGER_ERR, managerErr);
    }
    public String getManagerPhoneErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.MANAGER_PHONE_ERR, managerPhoneErr);
    }
    public String getManagerPhoneFormatErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.MANAGER_PHONE_FORMAT_ERR, managerPhoneFormatErr);
    }
    public String getEMachineRoomErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.E_MACHINE_ROOM_ERR, eMachineRoomErr);
    }
    public String getEDeviceErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.E_DEVICE_ERR, eDeviceErr);
    }

    public String getRayGroupOrgNameErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.RAY_GROUP_ORG_NAME_ERR, rayGroupOrgNameErr);
    }

    public String getRayGroupDepartmentNameErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.RAY_GROUP_DEPARTMENT_NAME_ERR, rayGroupDepartmentNameErr);
    }

    public String getRayGroupFoundingFileErrCn() {
        return CompanyErrorEnum.getCn(CompanyErrorEnum.RAY_GROUP_FOUNDING_FILE_ERR, rayGroupFoundingFileErr);
    }
}
