package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.hutool.core.lang.tree.Tree;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 组织机构-院区下地址和组织信息-vo
 * @Author: czq
 * @Creat: 2025-09-17 16:56
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class OrgCompanyAddressVo  implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 执业地址id
     */
    private Long id;
    /**
     * 院区id
     */
    private Long cid;
    /**
     * 执业地址名称
     */
    private String name;
    /**
     * 工作地址行政区划
     */
    private Long areaId;
    /**
     * 工作作地址详情（eg：水墩新路88号）
     */
    private String address;
    /**
     * 是否是院区主执业地址（1-是；0-否）
     */
    private Integer isMain;
    /**
     * 院区组织信息
     */
    private List<Tree<String>> orgTree;
}
