
package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
public @Data class CompanyChangeLogVo extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private Long id;

	//@ApiModelProperty("cid")
	private Long cid;

	//@ApiModelProperty("操作账号id")
	private Long userId;

	//@ApiModelProperty("操作账号")
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String username;

	//@ApiModelProperty("被编辑数据id")
	private Long dataId;

	//@ApiModelProperty("操作（insert、update、delete）")
	private String operation;

	//@ApiModelProperty("表名")
	private String tableName;

	//@ApiModelProperty("字段名称中文")
	private String fieldName;

	//@ApiModelProperty("字段名称en")
	private String fieldValue;

	//@ApiModelProperty("修改前字段值")
	private String beforeValue;

	//@ApiModelProperty("修改后字段值")
	@EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
	private String afterValue;

	//@ApiModelProperty("修改内容")
	private String content;

	//@ApiModelProperty("编辑时间")
	private Date editTime;

	//@ApiModelProperty("编辑批次编码（用于标记哪些字段是一起编辑的）")
	private Long batchCode;

	//@ApiModelProperty("审核日志id")
	private Long licenseId;

	//@ApiModelProperty("许可类型")
	private String licenseType;

	//@ApiModelProperty("许可状态（1-已许可；0-未许可）")
	private Integer licenseStatus;
}
