package cn.smarthse.rho.modules.sys.model.b.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;



/**
 * <p>
 * 医院：放射诊疗许可证同步信息
 * </p>

 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompanyCertSyncVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long cid;

    //@ApiModelProperty("源数据id")
    private String sourceId;

    //@ApiModelProperty("全国统一码")
    private String medicalNucode;

    //@ApiModelProperty(value = "同步时间（指的是wanda的同步时间，不是这条数据的更新时间）")
    private LocalDateTime syncTime;

    //@ApiModelProperty(value = "证书名称")
    private String name;

    //@ApiModelProperty(value = "许可编号")
    private String certNo;

    //@ApiModelProperty(value = "放射诊疗类别")
    private String rName;

    //@ApiModelProperty(value = "发证日期")
    private LocalDateTime beginDate;

    //@ApiModelProperty(value = "失效日期")
    private LocalDateTime endDate;





}
