package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;



/**
 * <p>
 * 员工同步
 * </p>
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CStaffInfoSyncVo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;


    //@ApiModelProperty(value = "同步时间（指的是wanda的同步时间，不是这条数据的更新时间）")
    private LocalDateTime syncTime;

    //@ApiModelProperty(value = "来源id")
    private String sourceId;

    //@ApiModelProperty(value = "姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty(value = "手机号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    //@ApiModelProperty(value = "身份证类型")
    private String idcardType;


    //@ApiModelProperty(value = "人员id")
    private Long staffBaseInfoId;

    //@ApiModelProperty(value = "身份证")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idcard;

    //@ApiModelProperty(value = "性别 0-女；1-男")
    private Integer sex;

    //@ApiModelProperty(value = "年龄")
    private Integer age;

    //@ApiModelProperty(value = "出生日期")
    private LocalDate birthday;

    //@ApiModelProperty(value = "岗位")
    private Long post;


    //@ApiModelProperty(value = "职业照射种类及代码")
    private String raType;
    //培训证书类型
    private String trainingCertType;

    //@ApiModelProperty(value = "更新时间", hidden = true)
    private LocalDateTime editTime;

    //@ApiModelProperty(value = "数据来源（1同步 2单位新增）")
    private Integer source;

    //@ApiModelProperty(value = "工号")
    private String workNo;

    //@ApiModelProperty(value = "需要关联的体检列表")
    private List<CHealthCheckData> healthCheckList;


    //@ApiModelProperty(value = "需要生成人员id的体检数据id列表")
    private String healthCheckIdListStr;


    //@ApiModelProperty(value = "需要关联的个人剂量id列表")
    private List<CDoseData> doseCheckList;


    //@ApiModelProperty(value = "需要生成人员id的体检数据id列表")
    private String doseCheckIdListStr;



    private List<CTrainingCert> trainingCheckList;


    private String trainingCheckIdListStr;



}
