package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 医院：公告栏制度规程-vo
 * @Author: czq
 * @Creat: 2025-10-10 14:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BCompanyBulletinListVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;
    /**
     * 企业Id
     */
    private Long cid;
    /**
     * 制度/规程 名称
     */
    private String name;
    /**
     * 附件类型：1=管理制度，2=操作规程
     */
    private Byte type;
    /**
     * 管理制度编号（CompanyCategoryCodeEnum）
     */
    private Integer categoryCode;
    /**
     * 附件id
     */
    private Long fileId;
    /**
     * 附件名称
     */
    private String fileName;
    /**
     * 附件url
     */
    private String fileUrl;
    /**
     * 附件类型后缀
     */
    private String fileExt;
    /**
     * 操作人
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String operatorName;
    /**
     * 操作时间
     */
    private LocalDateTime operateTime;

}
