package cn.smarthse.rho.modules.sys.model.b.vo;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;




/**
 * <p>
 * 医院：放射诊疗许可证Vo
 * </p>
 *
 * @author chenliang
 * @since 2024-03-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="BCertVo", description="医院：放射诊疗许可证Vo")
public class BCertVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    //@ApiModelProperty(value = "证书id")
    private Long certId;

    private Long cid;

    //@ApiModelProperty(value = "证书名称")
    private String name;

    //@ApiModelProperty(value = "发证日期")
    private LocalDateTime beginDate;

    //@ApiModelProperty(value = "失效日期")
    private LocalDateTime endDate;

    //@ApiModelProperty(value = "最近一次校验日期")
    private LocalDateTime lastVerificationDate;

    //@ApiModelProperty(value = "下一次校验日期")
    private LocalDateTime nextVerificationDate;

    //@ApiModelProperty(value = "校验超期天数")
    private Integer verificationOverdue;

    //@ApiModelProperty(value = "距离校验日期剩余时间（天数）")
    private Integer remainingTime;

    //@ApiModelProperty(value = "预警类型(0无预警无超期 2黄色预警)")
    private Integer warningType;

    //@ApiModelProperty(value = "RadiationScopeEnum code")
    private String r;

    //@ApiModelProperty(value = "X射线影像诊断RadiationScopeEnum code")
    private String r1;

    //@ApiModelProperty(value = "介入放射学RadiationScopeEnum code")
    private String r2;

    //@ApiModelProperty(value = "核医学RadiationScopeEnum code")
    private String r3;

    //@ApiModelProperty(value = "放射治疗RadiationScopeEnum code")
    private String r4;

    //@ApiModelProperty(value = "X射线影像诊断RadiationScopeEnum code")
    private String r1Name;

    //@ApiModelProperty(value = "介入放射学RadiationScopeEnum code")
    private String r2Name;

    //@ApiModelProperty(value = "核医学RadiationScopeEnum code")
    private String r3Name;

    //@ApiModelProperty(value = "放射治疗RadiationScopeEnum code")
    private String r4Name;


    public String getR1Name() {
        return StrUtil.isEmpty(r) ? r1Name : EdeviceDiagnosisTypeEnum.getRadiationNamesByCodes(r,"&&");
    }

    public String getR2Name() {
        return StrUtil.isEmpty(r) ? r2Name : EdeviceDiagnosisTypeEnum.getNuclearNamesByCodes(r,"&&");
    }

    public String getR3Name() {
        return StrUtil.isEmpty(r) ? r3Name : EdeviceDiagnosisTypeEnum.getInterventionalNamesByCodes(r,"&&");
    }

    public String getR4Name() {
        return StrUtil.isEmpty(r) ? r4Name : EdeviceDiagnosisTypeEnum.getXrayNamesByCodes(r,"&&");
    }
}
