package cn.smarthse.rho.modules.sys.model.b.param.license;

import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 编辑参数
 * </p>
 *
 * @author chenliang
 * @since 2024-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BChangeLicenseGenParam implements Serializable {

    private static final long serialVersionUID = -2159774594197248877L;


    /**
     * 许可id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long cid;


    /**
     * 变更类型（LicenseChangeTypeEnum）
     */
    private String subType;


    /**
     * 业务id
     */
    private Long targetId;

    /**
     * 设备id
     */
    private List<Long> deviceIdList;

    /**
     * 佐证材料id
     */
    private Long fileId;

    /**
     * 场所关联关系集合
     */
    List<ERelationDto> relationDtoList;

    /**
     * 许可状态（LicenseStatusEnum）
     */
    private Integer adminLicenseStatus;

}
