package cn.smarthse.rho.modules.sys.model.b.param.license;

import cn.smarthse.rho.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * 许可管理-设备参数
 * @author chuhy
 * @date 2025/10/20 14:28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BChangeLicenseDeviceParam extends PageParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -5072906465007988887L;


    /**
     * 设备id
     */
    private Long deviceId;

    /**
     * 设备类型
     */
    private Integer deviceType;

    /**
     * 许可状态(1-未许可；2-已许可；3-许可注销)
     */
    private List<Integer> licenseStatusList;

    /**
     * 文件id
     */
    private Long fileId;

}
