package cn.smarthse.rho.modules.sys.model.b.param;

import cn.smarthse.rho.modules.sys.enums.health.HealthCheckResultEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;



/**
 * <p>
 * 医院：统计维护参数
 * </p>
 *
 * @author chenliang
 * @since 2024-04-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BStatisticsMaintenanceParam implements Serializable{
    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("年份")
    private Integer year;

    //@ApiModelProperty("医院id")
    private List<Long> cidList;

    //@ApiModelProperty("当前日期")
    private LocalDate currDate;

    //@ApiModelProperty("当前时间")
    private LocalDateTime currDateTime;

    //@ApiModelProperty("有效时间间隔(年)")
    private Integer effectiveYear = 2;

    //@ApiModelProperty("有效时间间隔(天)")
    private Integer effectiveDay = 30;

    private Integer licenseManagement = RiskTypeEnum.LICENSE_MANAGEMENT.getValue();
    private Integer performanceTest = RiskTypeEnum.PERFORMANCE_TEST.getValue();
    private Integer performanceTestYc = RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue();
    private Integer placeTest = RiskTypeEnum.PLACE_TEST.getValue();
    private Integer placeTestYc = RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue();
    private Integer physicalExamination = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
    private Integer doseMonitoring = RiskTypeEnum.DOSE_MONITORING.getValue();
    private Integer doseMonitoringBigDose = RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue();
    private Integer training = RiskTypeEnum.TRAINING.getValue();
    private Integer three = RiskTypeEnum.THREE.getValue();
    private Integer grfh = RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue();
    private Integer aqjs = RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue();


    private String hcYszybCode = HealthCheckResultEnum.YSZYB.getValue();
    private String hcZyjjzCode = HealthCheckResultEnum.ZYJJZ.getValue();
    private String hcFcCode = HealthCheckResultEnum.FC.getValue();
}
