package cn.smarthse.rho.modules.sys.model.a.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 许可校验-医院基础信息
 * </p>
 *
 * @author chenliang
 * @since 2024-07-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CheckInfoCompanyVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("公司id")
    private Long cid;

    //@ApiModelProperty("审核id")
    private Long licenseId;

    //@ApiModelProperty("公司名称")
    private String cname;

    //@ApiModelProperty("公司地址")
    private String address;

    //@ApiModelProperty("法定代表人")
    private String legalName;

    //@ApiModelProperty("法人代表联系电话")
    private String legalTel;

    //@ApiModelProperty("主要负责人")
    private String mainLeaderName;

    //@ApiModelProperty("主要负责人电话")
    private String mainLeaderTel;


    //@ApiModelProperty("公司名称(是否待变更许可)")
    private String cnameFlag;

    //@ApiModelProperty("公司地址(是否待变更许可)")
    private String addressFlag;

    //@ApiModelProperty("法定代表人(是否待变更许可)")
    private String legalFlag;

    //@ApiModelProperty("主要负责人(是否待变更许可)")
    private String mainLeaderFlag;

    public void genFlag(CheckInfoCompanyVo flag){
        if (flag == null){return;}
        this.cnameFlag = flag.getCnameFlag();
        this.addressFlag = flag.getAddressFlag();
        this.legalFlag = flag.getLegalFlag();
        this.mainLeaderFlag = flag.getMainLeaderFlag();
    }

}
