package cn.smarthse.rho.modules.sys.enums.wanda;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;


@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandaoptTypeEnum {


    ADD("新增", "1"),
    UPDATE("更新", "2"),
    DEL("删除", "3"),

    ;

    private final String name;
    private final String value;

    WandaoptTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static String getName(String value) {
        if (value == null) {
            return null;
        }
        for (WandaoptTypeEnum c : WandaoptTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public static WandaoptTypeEnum getState(Integer value) {
        if (value == null) {
            return null;
        }
        for (WandaoptTypeEnum c : WandaoptTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return null;
    }
}
