package cn.smarthse.rho.modules.sys.enums.wanda;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum WandaDataDealTypeEnum {

    IGNORE("忽略", 0),
    NORMAL("正常", 1),
    ERROR("异常", 2),

    ;

    private final String name;
    private final int code;

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (WandaDataDealTypeEnum c : WandaDataDealTypeEnum.values()) {
            if (c.getCode() == code) {
                return c.name;
            }
        }
        return null;
    }

}
